using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Cost up down numeric control
		///</summary>

		#endregion


	public class CostUpDown : GUI.controls.BaseControl
	{

		#region Controls

		private System.Windows.Forms.Label lblCurrency;
		/// <summary>
		/// Cost numeric up/down control
		/// </summary>
		public System.Windows.Forms.NumericUpDown UDCost;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// CostUpDown class constructor. Creates an instance of the control.
		/// </summary>
		public CostUpDown()
		{
			InitializeComponent();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// CostUpDown class constructor. Adds control to the existing container.
		/// </summary>
		/// <param name="container"></param>
		public CostUpDown(System.ComponentModel.IContainer container)
		{
			container.Add(this);
			InitializeComponent();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion


		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.lblCurrency = new System.Windows.Forms.Label();
			this.UDCost = new System.Windows.Forms.NumericUpDown();
			((System.ComponentModel.ISupportInitialize)(this.UDCost)).BeginInit();
			this.SuspendLayout();
			// 
			// lblCurrency
			// 
			this.lblCurrency.Location = new System.Drawing.Point(0, 0);
			this.lblCurrency.Name = "lblCurrency";
			this.lblCurrency.Size = new System.Drawing.Size(12, 20);
			this.lblCurrency.TabIndex = 9;
			this.lblCurrency.Text = "$";
			this.lblCurrency.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// UDCost
			// 
			this.UDCost.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.UDCost.DecimalPlaces = 2;
			this.UDCost.Location = new System.Drawing.Point(12, 0);
			this.UDCost.Maximum = new System.Decimal(new int[] {
																   99999,
																   0,
																   0,
																   0});
			this.UDCost.Name = "UDCost";
			this.UDCost.Size = new System.Drawing.Size(128, 20);
			this.UDCost.TabIndex = 8;
			this.UDCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.UDCost.Leave += new System.EventHandler(this.UDCost_Leave);
			// 
			// CostUpDown
			// 
			this.Controls.Add(this.lblCurrency);
			this.Controls.Add(this.UDCost);
			this.Name = "CostUpDown";
			this.Size = new System.Drawing.Size(140, 20);
			((System.ComponentModel.ISupportInitialize)(this.UDCost)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		#region Control Events

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Leave event handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void UDCost_Leave(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			UpDownBase udBase = (UpDownBase) sender;
			if (udBase.Text == string.Empty)
			{
				//This code seems crazy, but if you delete the text and tab off,
				//and the control's value is reset to what it was originally (got all that?), the value will not refresh.
				UDCost.Value = UDCost.Maximum;
				UDCost.Value = UDCost.Minimum;
			}
		}

		#endregion


	}
}